<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    SelectUpgradeUrlMethod()
  ===================================================*/

  function SelectUpgradeUrlMethod() {
    global $theme_path;

    DisplayTemplate($theme_path . "upgrade_select.html");
  }


  /*===================================================
    ShowFormUpgradeUrlSearch()
  ===================================================*/

  function ShowFormUpgradeUrlSearch() {

    // vars global configuration
    global $theme_path;

    // vars url & form
    global $query;

    // vars messages
    global $msg;

    // vars template
    global $link, $num_links, $pagination, $error_msg, $keyword;

    $tpl       = new Template();

    $keyword   = $query;
    $query     = "select * from idx_link where title like '%$query%'";

    $links_obj = new clsLink;
    $links_obj->query               = $query;
    $links_obj->table_name          = "idx_link";
    $links_obj->category_table_name = "idx_category";
    $links_obj->template_file       = $theme_path . "upgrade_search_rows.html";
    $links_obj->date_format         = $msg["10142"];
    $links_obj->paging              = true;
    $links_obj->pg_size             = 25;
    $links_obj->href                = "upgrade.php";
    $links_obj->more_param          = "&pflag=search&query=$keyword";
    $link                           = $links_obj->Display();
    $pagination                     = $links_obj->pagination;
    $num_links                      = $links_obj->record_count_of_display;

    if ($num_links == 0) {
      $tpl->assign('keyword', $keyword);
      $error_msg = $tpl->fetch('var:' . $msg["10141"]);
      DisplayTemplate($theme_path . "search_error.html", "\$error_msg,\$keyword");
    }
    else
      DisplayTemplate($theme_path . "upgrade_search.html", "\$link,\$num_links,\$pagination,\$keyword");
  }


  /*===================================================
    ShowFormUpgradeUrl()
  ===================================================*/

  function ShowFormUpgradeUrl() {

    // vars global configuration
    global $dbConn, $theme_path, $paid_link_day_period, $paid_link_price_factor;

    // vars url & form
    global $id;

    // vars messages
    global $msg;

    // vars template
    global $error_msg, $link_id, $title, $url, $description, 
             $category_path_with_link, $contact_name, $sponsored, $premium, 
             $expire, $sponsored_listing_period, $premium_listing_period, 
             $available_payment_systems, $periodprice, $currency_symbol;

    if (empty($link_id))
      $link_id = $id;

    // check for invalid link_id
    $query  = "select a.*, b.*, premium, sponsored, expire, paid
               from idx_link a
                    left join idx_category_path b on (a.category_id = b.category_id)
                    left join idx_paid_listing c on (a.link_id = c.link_id)
               where a.link_id = '$link_id'";
    $result = $dbConn->Execute($query);

    if ($result) {
      $lid                     = $result->Fields('link_id');
      $title                   = $result->Fields('title');
      $url                     = $result->Fields('url');
      $description             = $result->Fields('description');
      $category_path_with_link = $result->Fields('path_with_url');
      $contact_name            = $result->Fields('contact_name');
      $category_id             = $result->Fields('category_id');
      $raw_premium             = $result->Fields("premium");
      $raw_sponsored           = $result->Fields("sponsored");
      $raw_expire              = $result->Fields("expire");
      $raw_paid                = $result->Fields("paid");

      $premium       = 0;
      $sponsored     = 0;

      if ($raw_paid == 1 &&
          $raw_premium == 1 &&
          @strtotime("now") < @strtotime($raw_expire)) {
            $premium   = 1;
            $sponsored = 0;
      }

      if ($raw_paid == 1 &&
          $raw_sponsored == 1 &&
          @strtotime("now") < @strtotime($raw_expire)) {
            $premium   = 0;
            $sponsored = 1;
      }

      $expire = $raw_expire;

    }

    if ($lid == "") {
      $error_msg = $msg['10148'];
      DisplayTemplate($theme_path . "upgrade_select.html", "\$error_msg");
      RunPostFilter(__FILE__);
    }

    // get payment system
    $query           = "select sponsored_price, premium_price from idx_category where category_id = '$category_id'";
    $result          = $dbConn->Execute($query);
    $sponsored_price = $result->Fields("sponsored_price");
    $premium_price   = $result->Fields("premium_price");

    // period and price factor
    $period       = @explode(',', $paid_link_day_period);
    $price_factor = @explode(',', $paid_link_price_factor);
    $i = 0;
    
    while (list($k, $v) = @each($period)) {
      if ($k == 0) {
        $default_day = $v;
      }
      if ($sponsored_price) {
        $price_no_disc                            = ($v / $default_day) * $sponsored_price;
        $sponsored_listing_period[$k]['period']   = $v;
        $sponsored_listing_period[$k]['price']    = $price_factor[$k] * $sponsored_price;
        $sponsored_listing_period[$k]['disc']     = sprintf("%01.2f", ($price_no_disc - $sponsored_listing_period[$k]['price']) / $price_no_disc * 100);
        $sponsored_listing_period[$k]['save']     = $price_no_disc - $sponsored_listing_period[$k]['price'];
        if ($periodprice == "SPONSORED|$v|{$sponsored_listing_period[$k][price]}") {
          $sponsored_listing_period[$k]['selected']  = 'selected="selected"';
        }
      }

      if ($premium_price) {
        $price_no_disc                          = ($v / $default_day) * $premium_price;
        $premium_listing_period[$k]['period']   = $v;
        $premium_listing_period[$k]['price']    = $price_factor[$k] * $premium_price;
        $premium_listing_period[$k]['disc']     = sprintf("%01.2f", ($price_no_disc - $premium_listing_period[$k]['price']) / $price_no_disc * 100);
        $premium_listing_period[$k]['save']     = $price_no_disc - $premium_listing_period[$k]['price'];
        if ($periodprice == "PREMIUM|$v|{$premium_listing_period[$k][price]}") {
          $premium_listing_period[$k]['selected']  = 'selected="selected"';
        }
      }
      $i++;
    }

    $currency_symbol = $dbConn->Lookup("currency_symbol", "idx_invoice_config", "0 = 0");
    $available_payment_systems = GetPaymentSystems();

    DisplayTemplate($theme_path . "upgrade_form.html", "\$error_msg,\$title,\$link_id,\$url,\$description,\$category_path_with_link,\$contact_name,\$sponsored_listing_period,\$premium_listing_period,\$currency_symbol,\$available_payment_systems,\$sponsored,\$premium,\$expire");
  }


  /*===================================================
    ProcessFormUpgradeUrl()
  ===================================================*/

  function ProcessFormUpgradeUrl() {

    // vars global configuration
    global $dbConn, $site_url, $theme_path, $category_separator, $email_address;

    // vars url & form
    global $link_id, $periodprice, $gateway;

    // vars messages
    global $msg;

    list($listing_type, $listing_period, $listing_price) = @explode('|', $periodprice);

    // prepare var
    $total         = $listing_price;
    $currency_code = $dbConn->Lookup("currency_code", "idx_invoice_config", "0 = 0");
    $custom        = "{$_COOKIE[COOKIE_USERNAME]}&{$listing_type}&{$link_id}&{$listing_period}";
    $item_name     = "Upgrade {$listing_type} LISTING (ID: {$link_id})";
    $notify_url = $site_url . "/payment/{$gateway}.check-upgrade.php";
    if ($_COOKIE['COOKIE_USERNAME']) {
      $return_url = $site_url . "/cp/mylisting.php";
      $cancel_url = $site_url . "/cp/mylisting.php";
    }
    else {
      $return_url = $site_url . "/paynow.php?res=ok&s=upgrade";
      $cancel_url = $site_url . "/index.php";
    }

    // route to selected payment system
    include "payment/" . $gateway . ".inc.php";
    include "payment/" . $gateway . ".php";
  }


  /*===================================================
    main
  ===================================================*/

  include "application.php";

  RunPreFilter(__FILE__);

  if (empty($pflag)) {
    SelectUpgradeUrlMethod();
  }
  elseif ($pflag == 'search') {
    ShowFormUpgradeUrlSearch();
  }
  elseif ($pflag == 'retrieve') {
    ShowFormUpgradeUrl();
  }
  elseif ($pflag == 'upgrade') {
    ProcessFormUpgradeUrl();
  }

  RunPostFilter(__FILE__);

?>